package ch.frankel.blog.spring.authoring.ehcache;

import static junit.framework.Assert.assertEquals;
import static net.sf.ehcache.store.MemoryStoreEvictionPolicy.FIFO;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import net.sf.ehcache.Ehcache;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:beans-ehcache.xml")
public class EhCacheNamespaceIntegrationTest {

	@Resource
	@Qualifier("myCache")
	private Ehcache namedCache;

	@Resource
	@Qualifier("org.springframework.cache.ehcache.EhCacheFactoryBean#0")
	private Ehcache anonymousCache;

	/**
	 * Test the &lt;ehcache:cache /&gt; attributes definition.
	 */
	@Test
	public void testParseAttribute() {

		assertNotNull(namedCache);

		assertTrue(namedCache.getCacheConfiguration().isEternal());
		assertFalse(namedCache.getCacheConfiguration().isOverflowToDisk());
		assertEquals(5, namedCache.getCacheConfiguration().getMaxElementsInMemory());
		assertEquals(2, namedCache.getCacheConfiguration().getMaxElementsOnDisk());
		assertEquals("foo", namedCache.getName());
		assertEquals(18, namedCache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds());
		assertTrue(namedCache.getCacheConfiguration().isDiskPersistent());
		assertTrue(namedCache.getCacheConfiguration().isDiskPersistent());
		assertEquals(50, namedCache.getCacheConfiguration().getTimeToLiveSeconds());
		assertEquals(25, namedCache.getCacheConfiguration().getTimeToIdleSeconds());
		assertSame(FIFO, namedCache.getCacheConfiguration().getMemoryStoreEvictionPolicy());
	}

	/**
	 * Test the &lt;ehcache:cache /&gt; child tags definition.
	 */
	@Test
	public void testParseSequence() {

		assertNotNull(anonymousCache);

		assertEquals("baz", anonymousCache.getCacheManager().getName());
	}
}
